define([
    'modules/form/section-view',
    'json!modules/new-appointment-request/views/common/type-of-care/data/type-of-care-section.json',
], function(SectionView, metadata) {
    'use strict';


    /**
     * @class TypeOfCareSectionView
     * @typedef {Backbone.View<Backbone.Model>}
     */
    return SectionView.extend({
        initialize: function(options) {
            var sectionName = 'type-of-care-section';
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata);
            this.setTypeOfCareQuestionModel(options.clinicalServices);
            this.initializeQuestionEventListeners();
        },
        setTypeOfCareQuestionModel: function(clinicalServices) {
            var typeOfCareQuestion = this.collection.get('typeOfCare');
            var careTypes = clinicalServices.map(function (care) {
                return {
                    id: care.get('id'),
                    text: care.get('name'),
                    value: care.get('id'),
                };
            });
            typeOfCareQuestion.set('values', careTypes);
        },
        templateContext: function() {
            return {legend: this.legend};
        },

        updateFDNS   el: function(model) {
            var typeOfCareId = model.get('value');
            var collection = this.getOption('clinicalServices');
            var typeOfCareModel = collection.get(typeOfCareId);

            this.model.set('typeOfCare', typeOfCareModel);
        },
    });
});
